﻿* Encoding: UTF-8.






***Select your directory  (Seleccionar el directorio o carpeta)  .

cd 'C:\1 Suriname 2022\Analysis'  .

***Open the file (abrir el archivo)

GET  FILE= 'j Poverty2.sav' .

***Three variables have to be defined:  consumption aggregate (consum_pc), population weights (person) and division corresponding to 1 Gini each (division ) .
***(Tres variables se deben de definir:  el agregado de consumo (consum_pc), los ponderadores de población (person) y las divisiones correspondientes a un Gini cada una (division ).)

COMPUTE consum_pc = cons_pc .
COMPUTE person =  weight3.
COMPUTE division=0 .
EXECUTE .

***Note:  for the national Gini, put a constant in "division", (for example: division= 1).  (Nota: Para el Gini nacional, poner una constante en "división" (por ejemplo division= 1) )  .

***Without weights (sin los pesos ).

WEIGHT OFF.

***  Only positive consumption values (Solo valores positivos).

FILTER OFF.
USE ALL.
SELECT IF (consum_pc > 0).
EXECUTE.

***Sort by division and consumption aggregate.(Ordenar segun los grupos y ela agregado de consumo)

SORT CASES  BY division consum_pc.
SPLIT FILE LAYERED BY division .

***Compute expanded consumption value for each household by multipling it by the population weights.
***(Estimar elconsumo expandido de cada hogar multiplicando su consumo por el ponderador de población)

COMPUTE VAL_TOT_H = consum_pc * person.
VARIABLE LABELS VAL_TOT_H 'Expanded consumption/household (consumo expandido/Hogar)' .


***Expanded population is the same as the population weights (la población expandida es igual a los ponderadores de población)

COMPUTE PER_TOT_H = person.
VARIABLE LABELS PER_TOT_H 'Expanded total population/househols (Personas totales expandidas/hogar)' .
EXECUTE.

***Estimate total expanded consumption and population (Estimar total expandido de consumo y de personas) .

AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=division
  /  VAL_TOT 'Expanded consumption (consumo expandido)' = SUM(VAL_TOT_H) 
   /PER.TOT 'Expanded total population (Personas totales expandidas)' = SUM(PER_TOT_H).

***Estimate proportion each household represent of total consumption and total population.
***(Estimar la proporción que cada hogar representa del valor total de consumo y de la población total para cada grupo.) 

COMPUTE VAL.PROPORCION = VAL_TOT_H / VAL_TOT .
VARIABLE LABELS VAL.PROPORCION 'Share of total consumption/houshehols (Proporción del consumo total/Hogar)' .
COMPUTE PER.PROPORCION = PER_TOT_H / PER.TOT .
VARIABLE LABELS PER.PROPORCION 'Share of total population/houshehols (Proporción de la poblaciónl/Hogar)'.
EXECUTE .

***Estimate the cumulative value for each household. Llast hoousheholds sshould have a 1 in consumption and poppulation for each group.
***(Estimar el valor acumulado de cada hogar.  Los últimos hogares deben de se 1 tanto tne consumo como población para cada grupo).

SORT CASES  BY division consum_pc.
SPLIT FILE LAYERED BY division .

CREATE
  /y.i=CSUM(VAL.PROPORCION).
CREATE
  /x.i=CSUM(PER.PROPORCION).

***Create the Lorenz curve (Crear la curva Lorenz) .

COMPUTE li45 = y.i .
EXECUTE .

formats x.i y.i li45 (f7.5) .
variable labels y.i 'Cumulative Lorenz curve consumption (Consumo acumulado de la curva Lorenz)' .
variable labels   x.i 'Cumulative Lorenz curve  population (Población acumulada de la curva Lorenz)' .
variable labels  li45'45 degrees line (Línea de 45 grados)'  .

GRAPH
  /SCATTERPLOT(OVERLAY)=x.i li45  WITH y.i y.i (PAIR)
  /MISSING=LISTWISE .

***Estimate the GINI coesfficient (Estimatar el coeficiente GINI)  

***  A.  For each household (para cada hogar) 

***     (X(i)-X(i-1)) * (Y(i) + Y(i-1))  

IF ( division = lag (division)) gi1 = (x.i - LAG(x.i)) * (y.i + LAG(y.i)) .
EXECUTE .

*** Sum the household values  for each division (sumar todos los valores individuales para cada división) 

AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=division
  /sum.gi1 'SUM {[X(i)-X(i-1)] * [Y(i)+Y(i-1)]}' = SUM(gi1).

*** B. For each divisions (Para cada división)

***    1 - [ SUM ((X(i)-X(i-1)) * (Y(i) + Y(i-1)) )  ]

COMPUTE gini = 1 - sum.gi1 .
VARIABLE LABELS gini 'GINI' .
EXECUTE .

AGGREGATE
  /OUTFILE= *
  /BREAK=division
  /gini=MEAN(gini).

compute gini= 100 * gini .
execute .

SAVE OUTFILE='BORRAR1.sav'
  /COMPRESSED.

****************************************************************************************************************************************************************.

***Open the file (abrir el archivo)

GET  FILE= 'j Poverty2.sav' .

***Three variables have to be defined:  consumption aggregate (consum_pc), population weights (person) and division corresponding to 1 Gini each (division ) .
***(Tres variables se deben de definir:  el agregado de consumo (consum_pc), los ponderadores de población (person) y las divisiones correspondientes a un Gini cada una (division ).)

COMPUTE consum_pc = cons_pc .
COMPUTE person =  weight3.
COMPUTE division=domain .
EXECUTE .

***Note:  for the national Gini, put a constant in "division", (for example: division= 1).  (Nota: Para el Gini nacional, poner una constante en "división" (por ejemplo division= 1) )  .

***Without weights (sin los pesos ).

WEIGHT OFF.

***  Only positive consumption values (Solo valores positivos).

FILTER OFF.
USE ALL.
SELECT IF (consum_pc > 0).
EXECUTE.

***Sort by division and consumption aggregate.(Ordenar segun los grupos y ela agregado de consumo)

SORT CASES  BY division consum_pc.
SPLIT FILE LAYERED BY division .

***Compute expanded consumption value for each household by multipling it by the population weights.
***(Estimar elconsumo expandido de cada hogar multiplicando su consumo por el ponderador de población)

COMPUTE VAL_TOT_H = consum_pc * person.
VARIABLE LABELS VAL_TOT_H 'Expanded consumption/household (consumo expandido/Hogar)' .


***Expanded population is the same as the population weights (la población expandida es igual a los ponderadores de población)

COMPUTE PER_TOT_H = person.
VARIABLE LABELS PER_TOT_H 'Expanded total population/househols (Personas totales expandidas/hogar)' .

***Estimate total expanded consumption and population (Estimar total expandido de consumo y de personas) .

AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=division
  /  VAL_TOT 'Expanded consumption (consumo expandido)' = SUM(VAL_TOT_H) 
   /PER.TOT 'Expanded total population (Personas totales expandidas)' = SUM(PER_TOT_H).

***Estimate proportion each household represent of total consumption and total population.
***(Estimar la proporción que cada hogar representa del valor total de consumo y de la población total para cada grupo.) 

COMPUTE VAL.PROPORCION = VAL_TOT_H / VAL_TOT .
VARIABLE LABELS VAL.PROPORCION 'Share of total consumption/houshehols (Proporción del consumo total/Hogar)' .
COMPUTE PER.PROPORCION = PER_TOT_H / PER.TOT .
VARIABLE LABELS PER.PROPORCION 'Share of total population/houshehols (Proporción de la poblaciónl/Hogar)'.
EXECUTE .

***Estimate the cumulative value for each household. Llast hoousheholds sshould have a 1 in consumption and poppulation for each group.
***(Estimar el valor acumulado de cada hogar.  Los últimos hogares deben de se 1 tanto tne consumo como población para cada grupo).

SORT CASES  BY division consum_pc.
SPLIT FILE LAYERED BY division .

CREATE
  /y.i=CSUM(VAL.PROPORCION).
CREATE
  /x.i=CSUM(PER.PROPORCION).

***Create the Lorenz curve (Crear la curva Lorenz) .

COMPUTE li45 = y.i .
EXECUTE .

formats x.i y.i li45 (f7.5) .
variable labels y.i 'Cumulative Lorenz curve consumption (Consumo acumulado de la curva Lorenz)' .
variable labels   x.i 'Cumulative Lorenz curve  population (Población acumulada de la curva Lorenz)' .
variable labels  li45'45 degrees line (Línea de 45 grados)'  .

GRAPH
  /SCATTERPLOT(OVERLAY)=x.i li45  WITH y.i y.i (PAIR)
  /MISSING=LISTWISE .

***Estimate the GINI coesfficient (Estimatar el coeficiente GINI)  

***  A.  For each household (para cada hogar) 

***     (X(i)-X(i-1)) * (Y(i) + Y(i-1))  

IF ( division = lag (division)) gi1 = (x.i - LAG(x.i)) * (y.i + LAG(y.i)) .
EXECUTE .

*** Sum the household values  for each division (sumar todos los valores individuales para cada división) 

AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK=division
  /sum.gi1 'SUM {[X(i)-X(i-1)] * [Y(i)+Y(i-1)]}' = SUM(gi1).

*** B. For each divisions (Para cada división)

***    1 - [ SUM ((X(i)-X(i-1)) * (Y(i) + Y(i-1)) )  ]

COMPUTE gini = 1 - sum.gi1 .
VARIABLE LABELS gini 'GINI' .
EXECUTE .

AGGREGATE
  /OUTFILE= *
  /BREAK=division
  /gini=MEAN(gini).

compute gini= 100 * gini .
execute .

ADD FILES /FILE=*
  /FILE='BORRAR1.sav'.
EXECUTE.

SORT CASES BY division(A).

value label division 0 "Surinam" 	1 "Great Paramaribo" 	2 "Rest of the coastal region" 	3 "Interior"  .

SAVE OUTFILE='k GINI2.sav'
  /COMPRESSED.

******.


GET  FILE='k GINI2.sav'.







ERASE  FILE='BORRAR1.sav'  . 



